/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.simdebug;

import com.ibm.hwmca.base.simdebug.ItemDescUtils;
import com.ibm.hwmca.base.simdebug.SysInfoErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.cparser.ParserObj;
import com.ibm.ui.framework.ActionDescriptor;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteEvent;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;

public class SysInfoManagerBean
extends PanelBean
implements TaskActionListener,
SysInfoErrorIds,
TaskNotifyCompleteListener {
    private static final String TRACE_MASKT = "XSIMBEAT";
    private static final String TRACE_MASKF = "XSIMBEAF";
    private static final String TRACE_MASKD = "XSIMBEAD";
    private static final char[] ASCII_ARRAY = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};
    private transient StringBuffer strCharBuf;
    private static final String APP_NAME = "SystemInfoManager";
    private static final String MENU = "SysInfoChoice";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(22, "SystemInfoManager");
    private String m_sAsciiOutput;
    private String m_sSysInfoChoice;
    private transient ValueDescriptor[] m_cdSysInfoChoice;
    private String m_sValueEdit;
    private int valueEditLen;
    private boolean hideIt;
    private transient String m_sValueEditSave;
    private transient String m_sKeyEdit;
    private transient ActionDescriptor[] m_adMenuChoice;
    private String[] simFields = null;

    public static char getASCIIChar(int i) {
        return ASCII_ARRAY[i];
    }

    public SysInfoManagerBean(String[] data) {
        this.simFields = data;
        this.hideIt = false;
        Trace.trace(TRACE_MASKT, "<> SysInfoManagerBean.constructor()");
    }

    public ValueDescriptor[] getSysInfoChoiceList() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getSysInfoChoiceList()");
        return this.m_cdSysInfoChoice;
    }

    public String getSysInfoChoice() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getSysInfoChoice()");
        return this.m_sSysInfoChoice;
    }

    public void setSysInfoChoice(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setSysInfoChoice(String s)");
        this.m_sSysInfoChoice = s;
    }

    public String getValueEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getValueEdit()");
        return this.m_sValueEdit;
    }

    public void setValueEdit(String s) {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setValueEdit()");
        this.m_sValueEditSave = this.m_sValueEdit;
        this.m_sValueEdit = s;
    }

    public void setAsciiOutput(String s) {
        this.m_sAsciiOutput = s;
    }

    public String getAsciiOutput() {
        Trace.trace(TRACE_MASKF, "-> SysInfoManagerBean.setAsciiOutput()");
        int hexLen = this.valueEditLen / 2;
        byte[] hexData = HexString.toHexBytes(this.m_sValueEdit);
        if (hexLen == 0) {
            this.m_sAsciiOutput = "";
        } else {
            StringBuffer strCharBuf = new StringBuffer(hexLen);
            for (int i = 0; i < hexLen; ++i) {
                strCharBuf.append(SysInfoManagerBean.getASCIIChar(ParserObj.toInt(hexData, 1, i)));
            }
            this.m_sAsciiOutput = strCharBuf.toString();
        }
        Trace.trace(TRACE_MASKF, "<- SysInfoManagerBean.setAsciiOutput()");
        return this.m_sAsciiOutput;
    }

    public void setValueEditLen(int len) {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setValueEditLen()");
        this.valueEditLen = len;
    }

    public void setHideIt(boolean hide) {
        this.hideIt = hide;
    }

    public void resetValueEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.resetValueEdit()");
        this.m_sValueEdit = this.m_sValueEditSave;
    }

    public String getKeyEdit() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getKeyEdit()");
        return this.m_sKeyEdit.toUpperCase();
    }

    public void setKeyEdit(String s) {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.setKeyEdit(String s)");
        this.m_sKeyEdit = s;
    }

    public ActionDescriptor[] getMenuChoiceList() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getMenuChoiceList()");
        return this.m_adMenuChoice;
    }

    public Capabilities getCapabilities() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.getCapabilities()");
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKF, "<> SysInfoManagerBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "-> SysInfoManagerBean.load()");
        try {
            this.m_sSysInfoChoice = "";
            this.m_sValueEdit = "";
            this.m_sKeyEdit = "";
            if (this.simFields != null) {
                this.m_sSysInfoChoice = this.simFields[0];
                this.m_cdSysInfoChoice = new ValueDescriptor[this.simFields.length];
                for (int i = 0; i < this.simFields.length; ++i) {
                    this.m_cdSysInfoChoice[i] = new ValueDescriptor(String.valueOf(i), this.simFields[i]);
                }
            } else {
                Trace.trace(TRACE_MASKF, "simField not set.");
            }
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 3, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- SysInfoManagerBean.load()");
    }

    public void update(Object bean) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.update(SysInfoManagerBean).");
        this.setValueEdit(((SysInfoManagerBean)bean).getValueEdit());
        if (this.userTaskManager != null) {
            if (this.hideIt) {
                this.userTaskManager.setEnabled("ApplyButton", false);
                this.userTaskManager.setEnabled("ValueEdit", false);
            } else {
                this.userTaskManager.setEnabled("ApplyButton", true);
                this.userTaskManager.setEnabled("ValueEdit", true);
            }
            this.userTaskManager.refreshElement("ValueEdit");
        } else {
            Trace.trace(TRACE_MASKD, "UserTaskManager not setup.");
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.update().");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.prepare().");
        this.userTaskManager.setNotifySelection(MENU, true);
        this.setSysInfoChoice(this.getSysInfoChoiceList()[0].getTitle());
        if (this.userTaskManager != null) {
            this.userTaskManager.refreshAllElements();
            SysInfoManagerBean bean = (SysInfoManagerBean)this.userTaskManager.getDataObjects()[0];
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", "LoadRun");
            request.setData("data", bean);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKD, "userTaskManager is null.");
        }
        this.userTaskManager.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)this, MENU);
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.prepare().");
    }

    protected void finalize() throws Throwable {
        Trace.trace(TRACE_MASKF, "--bean--in SIM finalize");
        super.finalize();
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.panelAction(TaskActionEvent).");
        String cmd = evt.getActionCommand();
        Trace.trace(TRACE_MASKF, "Command is " + cmd + ".");
        try {
            if (cmd.equals("CANCEL")) {
                Trace.trace(TRACE_MASKD, "Handler: Cancel button.");
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("event", cmd);
                this.postTaskletRequest(request);
            } else {
                UserTaskManager utm = (UserTaskManager)evt.getSource();
                if (utm == null) {
                    Trace.trace(TRACE_MASKD, "evt.getSource returned null for UserTaskManager.");
                } else {
                    utm.storeAllElements();
                    SysInfoManagerBean bean = (SysInfoManagerBean)utm.getDataObjects()[0];
                    if (cmd.equals("FindButton")) {
                        if (this.getKeyEdit() == null || this.getKeyEdit().length() == 0) {
                            BaseMessageTitle title = new BaseMessageTitle("XSIM8002");
                            BaseMessageText myMess = new BaseMessageText("XSIMB006");
                            CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)title, myMess, MsgType.INFORMATION_MESSAGE);
                        } else {
                            Trace.trace(TRACE_MASKF, "FIND: KeyEdit string = [" + this.getKeyEdit() + "].");
                            int[] row = utm.getSelectedRows(MENU);
                            int startRow = 0;
                            if (row != null && row.length > 0) {
                                startRow = row[0];
                            }
                            int[] id = new int[1];
                            Integer rowFound = null;
                            rowFound = ItemDescUtils.anArray(this.simFields, this.getKeyEdit(), ++startRow);
                            if (rowFound != null) {
                                Trace.trace(TRACE_MASKF, "simField index = " + id[0] + ".");
                                id[0] = rowFound;
                                this.setSysInfoChoice(this.getSysInfoChoiceList()[id[0]].getTitle());
                                utm.refreshAllElements();
                                PanelTaskletRequest request = new PanelTaskletRequest();
                                request.setData("event", "EditItem");
                                request.setData("data", bean);
                                this.postTaskletRequest(request);
                            } else {
                                BaseMessageTitle title = new BaseMessageTitle("XSIM8002");
                                BaseMessageText myMess = new BaseMessageText("XSIMB002");
                                CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)title, myMess, MsgType.INFORMATION_MESSAGE);
                            }
                        }
                    } else if (cmd.equals("ApplyButton")) {
                        Trace.trace(TRACE_MASKF, "APPLY button");
                        if (this.valueEditLen != this.m_sValueEdit.length() && this.valueEditLen != 0) {
                            BaseMessageTitle title = new BaseMessageTitle("XSIM8001");
                            Object[] arg = new String[]{new Integer(this.valueEditLen / 2).toString()};
                            BaseMessageText myMess = new BaseMessageText("XSIMB003", arg);
                            CommonMsgApp.showMessageBox(this.userTaskManager, (LocalizableText)title, myMess, MsgType.ERROR_MESSAGE);
                        } else {
                            Trace.trace(TRACE_MASKF, "APPLY: this.getValueEdit() = " + this.getValueEdit() + ".");
                            utm.refreshAllElements();
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("event", "ApplyButton");
                            request.setData("data", bean);
                            this.postTaskletRequest(request);
                        }
                    } else if (cmd.equals("ResetButton")) {
                        Trace.trace(TRACE_MASKF, "RESET: this.getValueEdit() = " + this.getValueEdit() + ".");
                        this.resetValueEdit();
                        utm.refreshElement("ValueEdit");
                    } else if (cmd.endsWith("EditItem")) {
                        Trace.trace(TRACE_MASKF, "EditItem:");
                        int[] row = utm.getSelectedRows(MENU);
                        if (row != null && row.length > 0) {
                            Trace.trace(TRACE_MASKF, "row = " + row[0]);
                            Trace.trace(TRACE_MASKF, "getName [" + this.getSysInfoChoiceList()[row[0]].getName() + "].");
                            Trace.trace(TRACE_MASKF, "getTitle [" + this.getSysInfoChoiceList()[row[0]].getTitle() + "].");
                            this.setSysInfoChoice(this.getSysInfoChoiceList()[row[0]].getTitle());
                            utm.refreshAllElements();
                            PanelTaskletRequest request = new PanelTaskletRequest();
                            request.setData("event", "EditItem");
                            request.setData("data", bean);
                            this.postTaskletRequest(request);
                        } else {
                            Trace.trace(TRACE_MASKF, "selected rows null of zero in length");
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "I don't know this button: " + cmd + ".");
                    }
                }
            }
        }
        catch (IllegalUserDataException ide) {
            Trace.trace(TRACE_MASKF, "SIM panelAction Caught illegal data exc.  Framework code will handle message");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in SysInfoManagerBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 5, he).log();
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("panelError", "panelErrorTerm");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.panelAction(TaskActionEvent).");
    }

    public void taskCompleted(TaskNotifyCompleteEvent evt) {
        Trace.trace(TRACE_MASKT, "-> SysInfoManagerBean.taskCompleted(TaskNotifyCompleteEvent).");
        UserTaskManager utm = (UserTaskManager)evt.getSource();
        int[] row = utm.getSelectedRows(MENU);
        if (row != null && row.length > 0) {
            Trace.trace(TRACE_MASKD, "row = " + row[0]);
            Trace.trace(TRACE_MASKD, "getName [" + this.getSysInfoChoiceList()[row[0]].getName() + "].");
            Trace.trace(TRACE_MASKD, "getTitle [" + this.getSysInfoChoiceList()[row[0]].getTitle() + "].");
            this.setSysInfoChoice(this.getSysInfoChoiceList()[row[0]].getTitle());
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", "EditItem");
            request.setData("data", this);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKF, "selected rows null of zero in length");
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoManagerBean.taskCompleted().");
    }
}

